/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xdownld.h
 *       Updating flash memory. Core/Bios-switching
 * -----------------------------------------------------------------*/

#ifndef XDOWNLOAD_H_INCLUDED
#define XDOWNLOAD_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

/* Enum to identify a E2929A style loadable component
 * never change order of entries.
 * Has to match with offset_lookup[] in loader.c !!!
 */

typedef enum {
  BX_FSEC_CORE,
  BX_FSEC_XILINX,
  BX_FSEC_FIRMWARE,
  BX_FSEC_DEVELOPER,
  BX_FSEC_LICENSE,
  BX_FSEC_VERSION,
  BX_FSEC_DEEPTRACEALTERA,
  BX_FSEC_LOADER,
  BX_FSEC_EXPROM,
  BX_FSEC_FRED
} bx_fsectiontype;


/* Enum for meaning of file names in device file vector in
 * hardware update
 */
typedef enum {
  BX_DEVFILE_CORE,
  BX_DEVFILE_BIOS,    /* do not change order!! */
  BX_DEVFILE_XILINX,
  BX_DEVFILE_DEEPTRACEALTERA,
  BX_DEVFILE_FRED,
  BX_DEVFILE_CORE2X,
  BX_DEVFILE_BIOS2X,    
  BX_DEVFILE_FAUSTSAFE,    
  BX_DEVFILE_FAUSTPCI,    
  BX_DEVFILE_FAUSTPCIX,    
  BX_DEVFILE_FAUSTPCIX2,    
  BX_DEVFILE_COUNT
} bx_devfiletype;


/********************************************************************
  Flash programming *************************************************
 *******************************************************************/

CLI bx_errtype EXPORT BestXCoreSwitch(  /* @coreswitch */
  bx_handletype handle
);

CLI bx_errtype EXPORT BestXBiosSwitch(   /* @biosswitch */
  bx_handletype handle,
  bx_int32 boot
);

bx_errtype BestXFlashProgPrepare(bx_handletype handle, bx_fsectiontype section);
bx_errtype BestXHexImageLoad(bx_handletype handle, bx_int8ptr heximag, bx_int32 no_of_bytes);
bx_errtype BestXHexImageProg(bx_handletype handle);

#ifdef __cplusplus
}
#endif



#endif
